----------------------------------
-- Zombie Plague Mini Functions --
----------------------------------

function zp_classes_ld()
	f = io.open(zp_dir..'classes.cfg','r')
	if (f ~= nil) then
		local class_cnt = 0
		local m = 0
		zp_print(3,'Classes File Found!')
		for line in f:lines() do
			m = m + 1
			if (string.sub(line, 1, 9) == '#addclass') then
				local breaking = 0
				class_cnt = class_cnt + 1
				local load_string = string.split(line,':')
				local i
				for i = 1, 6 do
					if (load_string[i + 1] ~= nil) then
						if (i > 1) then
							if (tonumber(load_string[i + 1]) > zp_max_class[i - 1] or tonumber(load_string[i + 1]) < zp_min_class[i-1]) then
								set_zm_stata(class_cnt,i,zp_med_class[i - 1])
								zp_print(4,'Zombie Class Parameter Too High! ('..m..' line) (Parameter '..i..')')
							else
								set_zm_stata(class_cnt,i,tonumber(load_string[i + 1]))
							end
						elseif (i < 2) then
							set_zm_stata(class_cnt,i,load_string[i + 1])
						end
					elseif (load_string[i + 1] == nil and breaking < 1) then
						zp_print(4,'Zombie Class Parameter Missing! ('..m..' line)')
						set_zm_stata(class_cnt,1,nil)
						breaking = 1
						class_cnt = class_cnt  - 1
					end
				end
				if (breaking == 0) then
					zp_print(6,'Zombie Class Added: '..set_zm_val(class_cnt,1))
				end
			end
		end
		zp_classes_cnt = class_cnt
		f:close()
	else
		zp_print(4,'Classes File Missing!')
	end
end

function zp_weapons_ld()
	f = io.open(zp_dir..'weapons.cfg','r')
	if (f ~= nil) then
		local weapon_cnt = 0
		local m = 0
		zp_print(3,' Weapons File Found!')
		for line in f:lines() do
			m = m + 1
			if (string.sub(line, 1, 10) == '#addweapon') then
				local breaking = 0
				weapon_cnt = weapon_cnt + 1
				local load_string = string.split(line,':')
				local i
				for i = 1, 5 do
					if (load_string[i + 1] ~= nil) then
						if (i > 1) then
							set_wpn_stata(weapon_cnt,i,tonumber(load_string[i + 1]))
						elseif (i < 2) then
							set_wpn_stata(weapon_cnt,i,load_string[i + 1])
						end
					elseif (load_string[i + 1] == nil and breaking < 1) then
						zp_print(4,'Weapon Parameter Missing! ('..m..' line)')
						set_wpn_stata(weapon_cnt,1,nil)
						breaking = 1
						weapon_cnt = weapon_cnt  - 1
					end
				end
				
				if (breaking == 0) then
					zp_print(6,'Weapon Added: '..set_wpn_val(weapon_cnt,1)..' (Level: '..set_wpn_val(weapon_cnt,3)..')')
					zp_wpn_dmg[set_wpn_val(weapon_cnt,2)] = set_wpn_val(weapon_cnt,5)
					zp_wpn_knock[set_wpn_val(weapon_cnt,2)] = set_wpn_val(weapon_cnt,4)
				end
			end
		end
		zp_weapons_cnt = weapon_cnt
		f:close()
	else
		zp_print(4,'Weapons File Missing!')
	end
end

function zp_wpndmg_set()
	local m
	for m = 1, zp_weapons_cnt do
		parse('mp_wpndmg "'..itemtype(set_wpn_val(m,2),'name')..'" '..2 * set_wpn_val(m,5))
	end
end

function zp_player_sv(p)
	if (player(p,"usgn") > 0) then
		f = assert(io.open(zp_dir..'data/'..player(p,"usgn")..'.txt','w'))
		f:write(set_player_val(p,1)..'\n'..set_player_val(p,2))
		f:close()
	end
end

function zp_player_ld(p)
	local usgn = player(p,"usgn")
	if (usgn > 0) then
		zp_msg2(p,3,'Your U.S.G.N. ID: '..usgn..'@C')
		zp_hudtxt2(p,3,2,'Logged in: #'..usgn,5,410,0)
		f = io.open(zp_dir..'data/'..usgn..'.txt','r')
		if (f ~= nil) then
			zp_msg2(p,2,'Your Save File Found!@C')
			local i = 0
			local s = 0
			local c = 0
			for line in f:lines() do
				i = i + 1
				if (i < 3) then set_player_stata(p,i,tonumber(line)) end
			end
			while set_player_val(p,1) >= c and s < zp_lvl_max do
				s = s + 1
				c = c +zp_lvl_ratio * s
			end
			if (s > zp_lvl_max) then i = zp_lvl_max end
			set_player_stata(p,3,s)
			set_player_stata(p,4,c)
			f:close()
		else
			zp_msg2(p,4,'Failed To Load Save!@C')
		end
	else
		zp_msg2(p,4,'Please check your U.S.G.N. account settings!@C')
		zp_hudtxt2(p,3,4,'Logged to login!',5,410,0)
	end
	
	if (set_player_val(p,1) == nil or set_player_val(p,1) < 1 or usgn < 1) then
		zp_player_reset(p)
	end
end

function zp_player_hud(p)
	local t = player(p,'team')
	if (t == 1) then
		zp_hudtxt2(p,2,8,'Health: '..zp_p_health[p]..' - Class: '..set_zm_val(zp_p_class[p],1)..' - Ammo Packs: '..set_player_val(p,2)..' - Level: '..set_player_val(p,3)..'/'..zp_lvl_max..' - Experience: '..set_player_val(p,1)..'/'..set_player_val(p,4),5,425,0)
	elseif (t == 2) then
		zp_hudtxt2(p,2,9,'Class: Human - Ammo Packs: '..set_player_val(p,2)..' - Level: '..set_player_val(p,3)..'/'..zp_lvl_max..' - Experience: '..set_player_val(p,1)..'/'..set_player_val(p,4),5,425,0)
	end
end

function zp_player_reset(p)
	set_player_stata(p,1,0)
	set_player_stata(p,2,zp_pack_start)
	set_player_stata(p,3,zp_lvl_start)
	set_player_stata(p,4,zp_lvl_ratio)
end

function zp_level_up(p,n)
	local t = player(p,'team')
	while (set_player_val(p,1) >= set_player_val(p,4) and set_player_val(p,3) < zp_lvl_max) do
		set_player_statb(p,3,1)
		set_player_statb(p,4,set_player_val(p,3) * zp_lvl_ratio)
		if (n > 0) then
			zp_msg2(p,2,'Level Up!@C')
			zp_msg(5,player(p,'name')..' Reached '..set_player_val(p,3)..' Level!')
		end
	end
end

function zp_zombie_set(p)
	zp_tile_hit[p] = 0
	if (player(p,'bot') and p ~= zp_nemesis_id) then
		zp_p_class[p] = math.random(1,zp_classes_cnt)
	end
	zp_p_stun[p] = 0
	local pl_class = zp_p_class[p]
	if (set_zm_val(zp_p_class[p],2) < 250) then
		parse('setmaxhealth '..p..' '..set_zm_val(pl_class ,2))
		parse('sethealth '..p..' '..set_zm_val(pl_class ,2))
	else
		parse('setmaxhealth '..p..' 250')
		parse('sethealth '..p..' 250')
	end
	parse('speedmod '..p..' '..set_zm_val(pl_class,3))
	if (set_zm_val(pl_class,6) > 0) then
		parse('equip '..p..' '..set_zm_val(pl_class,6))
		parse('setweapon '..p..' '..set_zm_val(pl_class,6))
	end
end

function zp_class_check(p)
	if (zp_p_class[p] == 0) then
		zp_class_menu_id[p] = 0
		zp_menu_class(p)
	end
end

function zp_menu_weapon(p)
	if (player(p,'team') == 2) then
		local i
		local weapon = ''
		local id = zp_wpn_menu_id[p]
		if (id == 0) then
			for i = 1, 8 do
				if (set_wpn_val(i,1) ~= nil) then
					if (zp_weapons_unlock > 0) then
						if (set_player_val(p,3) >= set_wpn_val(i,3)) then
							weapon = weapon..''..set_wpn_val(i,1)..'|(Level '..set_wpn_val(i,3)..'),'
						else
							weapon = weapon..'(Locked)|(Level '..set_wpn_val(i,3)..'),'
						end
					else
						weapon = weapon..''..set_wpn_val(i,1)..'|(Level '..set_wpn_val(i,3)..'),'
					end
				end
			end
			if (set_wpn_val(9,1) ~= nil) then 
				weapon = weapon..'Next|More'
			end
		elseif (id > 0) then
			for i = 9 + 7 * (id - 1), 15 +  7 * (id - 1) do
				if (set_wpn_val(i,1) ~= nil) then
					if (zp_weapons_unlock > 0) then
						if (set_player_val(p,3) >= set_wpn_val(i,3)) then
							weapon = weapon..''..set_wpn_val(i,1)..'|(Level '..set_wpn_val(i,3)..'),'
						else
							weapon = weapon..'(Locked)|(Level '..set_wpn_val(i,3)..'),'
						end
					else
						weapon = weapon..''..set_wpn_val(i,1)..'|(Level '..set_wpn_val(i,3)..'),'
					end
				else
					weapon = weapon..','
				end
			end
			weapon = weapon..'Back|Previuos,'
			if (15 +  7 * (id - 1) < zp_weapons_cnt) then 
				weapon = weapon..'Next|More'
			end
		end
		menu(p,'Choose Weapon (Page '..(1 + id)..'),'..weapon)
	else
		zp_msg2(p,4,'[ZP] Only For Survivors!')
	end
end	

function zp_knockback_init()
	f = io.open('maps/'..map('name')..'_knockback.txt','r')
	if (f ~= nil) then
		zp_print(3,'Knockback Map File Found!')
		zp_print(2,'Knockback Enabled!')
		local x
		local y = 0
		for line in f:lines() do
			for x = 0, (#line) do
				if (string.sub(line, x+1, x+1) == "#") then
					zp_map_tile[x.."_"..y] = 1
				else
					zp_map_tile[x.."_"..y] = 0
				end
			end
			y = y + 1
		end
		f:close()
	else
		zp_print(4,'Knockback Map File Missing For ('..map('name')..') Map!')
		zp_print(4,'Knockback Dissabled!')
		zp_knockback = 0
	end
end

function zp_knockback_check(x,y)
	if (zp_map_tile[x.."_"..y] == 1) then
		return 1
	else
		return 0
	end
end

function zp_knockback_func(p,v,w)
	if (w < 99 and zp_knockback > 0) then
		local knock
		if (zp_wpn_knock[w] ~= nil) then
			knock = zp_wpn_knock[w]
		else
			knock = itemtype(w,'dmg') / 2
		end
		local rot = player(p,'rot')
		if (rot < -90) then rot = rot + 360 end
		local ang = math.rad(math.abs(rot + 90 )) - math.pi
		local x = player(v,'x') + math.cos(ang) * (knock * (set_zm_val(zp_p_class[v],4)/5))
		local y = player(v,'y') + math.sin(ang) * (knock * (set_zm_val(zp_p_class[v],4)/5))
		if (zp_knockback_check(math.ceil(x/32)- 1,math.ceil(y/32)-1) == 0) then
			zp_tile_x[v] = player(v,'x')
			zp_tile_y[v] = player(v,'y')
			zp_tile_hit[v] = 1
			parse('setpos '..v..' '..x..' '..y)
		end
	end
end

function zp_create_flashlight()
	if (zp_hud_flashlight > 0) then
		for i = 1,32,1 do
			img = image("gfx/zombieplague/zp_flashlight.png",1,1,100 + i)
			imagecolor(img,255,255,255)
			imageblend(img,1)
			imagealpha(img,zp_hud_alpha / 10)
		end
	end
end

function zp_light_set(p)
	local t = player(p,'team')
	zp_light_eng[p] = 100
	zp_light_state[p] = -zp_hud_waste
	if (t == 2) then
		zp_hudtxt2(p,4,2,'Flashlight: 100% (Charged)',635,390,2)
	elseif (t == 1) then
		zp_hudtxt2(p,4,2,'',0,0,0)
	end
end

function zp_light_update(p)
	local t = player(p,'team')
	if (t == 2 and player(p,'exists') and player(p,'health') > 0) then
		zp_light_eng[p] = zp_light_eng[p] + zp_light_state[p]
		if (zp_light_eng[p] < 0) then
			zp_light_eng[p] = 0
			zp_light_state[p] = zp_hud_recovery
		elseif (zp_light_eng[p] > 100) then
			zp_light_eng[p] = 100
		end
		local states = {'Low','Weak','Medium','High','Charged'}
		local state = ''
		local clrs = {'255000000','255000000','255185000','155255000','000255000'}
		local clr = ''
		for i = 1,5 do
			if (zp_light_eng[p] >= 20 * ( i - 1) and zp_light_eng[p] <= 20 * i) then
				state =  states[i]
				clr = clrs[i]
			end
		end		
		parse('hudtxt2 '..p..' 4 "'..clr..'Flashlight: '..zp_light_eng[p]..'% ('..state..')" 635 390 2')
		if (zp_light_state[p] < 1) then
			imagealpha(p,(zp_hud_alpha / 10) * (0.2 + zp_light_eng[p]/200))
		else
			imagealpha(p,0)
		end
	else
		imagealpha(p,0)
	end
end

function zp_menu_class(p)
	local item
	local dmg
	local i
	local class = ''
	local id = zp_class_menu_id[p]
	if (id == 0) then
		for i = 1, 8 do
			if (set_zm_val(i,1) ~= nil) then
				if (set_zm_val(i,6) > 0) then
					item = 'Item: '..itemtype(set_zm_val(i,6),'name')
				else
					item = ''
				end
				if (set_zm_val(i,5) > 0) then
					dmg = zp_zm_state[math.ceil(set_zm_val(i,5)/5)]
				else
					dmg = '1 hit'
				end
				class = class..''..set_zm_val(i,1)..'|HP'..zp_zm_state[math.ceil(set_zm_val(i,2) / 2500)]..' Speed'..zp_zm_state[math.ceil((10 + set_zm_val(i,3)) / 2)]..' Knock'..zp_zm_state[10 - set_zm_val(i,4)]..' DMG'..dmg..' '..item..','
			end
		end
		if (set_zm_val(9,1) ~= nil) then 
			class = class..'Next|More'
		end
	elseif (id > 0) then
		for i = 9 + 7 * (id - 1), 15 +  7 * (id - 1) do
			if (set_zm_val(i,1) ~= nil) then
				if (set_zm_val(i,6) > 0) then
					item = 'Item: '..itemtype(set_zm_val(i,6),'name')
				else
					item = ''
				end
				if (set_zm_val(i,5) > 0) then
					dmg = zp_zm_state[math.ceil(set_zm_val(i,5)/5)]
				else
					dmg = '1 hit'
				end
				class = class..''..set_zm_val(i,1)..'|HP'..zp_zm_state[math.ceil(set_zm_val(i,2) / 2500)]..' Speed'..zp_zm_state[math.ceil((10 + set_zm_val(i,3)) / 2)]..' Knock'..zp_zm_state[10 - set_zm_val(i,4)]..' DMG'..dmg..' '..item..','
			else
				class = class..','
			end
		end
		class = class..'Back|Previuos,'
		if (15 +  7 * (id - 1) < zp_classes_cnt) then 
			class = class..'Next|More'
		end
	end
	menu(p,'Zombie Class (Page '..(1 + id)..')@b,'..class)
end

function zp_help_ld()
	f = io.open(zp_dir..'advertise.txt','r')
	if (f ~= nil) then
		local m = 0
		zp_print(3,'Help File Found!')
		for line in f:lines() do
			m = m + 1
			zp_help_line[m] = line
		end
		f:close()
	else
		zp_print(4,'Help File Missing!')
	end
end

function zp_help_show(p)
	local i
	for i = 1, #zp_help_line do
		zp_hudtxt2(p,25 + i,2,zp_help_line[i],460,25 + 15 * i,0)
	end
end

function zp_nemesis_form()
	local ct_nem = zp_ct_table()
	if (zp_ct_cnt() > 0) then
		zp_snd(math.random(9,10))
		zp_nemesis_id = ct_nem[math.random(1,zp_ct_cnt())]
		local n = zp_nemesis_id
		zp_p_class[n] = -1
		zp_msg(8,player(n,'name')..' is Nemesis!@C')
		local x = player(n,'x')
		local y = player(n,'y')
		parse('maket '..n)
		parse('spawnplayer '..n..' '..x..' '..y)
		zp_player_hud(n)
		if (zp_hud_flashlight > 0) then	imagealpha(n,0) end
	end
end


function zp_hm_items_menu(p)
	if (player(p,'team') == 2) then
		if (zp_items_human > 0) then
			local i
			local items = ''
			local id = zp_item_menu_id[p]
			if (id == 0) then
				for i = 1, 8 do
					if (set_ct_item_val(i,1) ~= nil) then
						if (set_ct_item_val(i,5) == nil and set_ct_item_val(i,6) == nil) then
							items = items..''..set_ct_item_val(i,1)..' (Building)|'..set_ct_item_val(i,2)..' APs,'
						else
							items = items..''..set_ct_item_val(i,1)..'|'..set_ct_item_val(i,2)..' APs,'
						end
					end
				end
				if (set_ct_item_val(9,1) ~= nil) then 
					items = items..'Next|More'
				end
			elseif (id > 0) then
				for i = 9 + 7 * (id - 1), 15 +  7 * (id - 1) do
					if (set_ct_item_val(i,1) ~= nil) then
						if (set_ct_item_val(i,5) == nil and set_ct_item_val(i,6) == nil) then
							items = items..''..set_ct_item_val(i,1)..' (Building)|'..set_ct_item_val(i,2)..' APs,'
						else
							items = items..''..set_ct_item_val(i,1)..'|'..set_ct_item_val(i,2)..' APs,'
						end
					else
						items = items..','
					end
				end
				items = items..'Back|Previuos,'
				if (15 +  7 * (id - 1) < zp_ct_items_cnt) then 
					items = items..'Next|More'
				end
			end
			menu(p,'Human Shop (Page '..(1 + id)..'),'..items)
		else
			zp_msg2(p,4,'This Feature Disabled By Admin!@C')
		end
	else
		zp_msg2(p,4,'[ZP] These Items Only For Survivors!')
	end
end

function zp_zm_items_menu(p)
	if (player(p,'team') == 1) then
		if (zp_items_zombie > 0) then
			local i
			local items = ''
			local id = zp_item_menu_id[p]
			if (id == 0) then
				for i = 1, 8 do
					if (set_zm_item_val(i,1) ~= nil) then
						items = items..''..set_zm_item_val(i,1)..'|'..set_zm_item_val(i,2)..' APs,'
					end
				end
				if (set_zm_item_val(9,1) ~= nil) then 
					items = items..'Next|More'
				end
			elseif (id > 0) then
				for i = 9 + 7 * (id - 1), 15 +  7 * (id - 1) do
					if (set_zm_item_val(i,1) ~= nil) then
						items = items..''..set_zm_item_val(i,1)..'|'..set_zm_item_val(i,2)..' APs,'
					else
						items = items..','
					end
				end
				items = items..'Back|Previuos,'
				if (15 +  7 * (id - 1) < zp_zm_items_cnt) then 
					items = items..'Next|More'
				end
			end
			menu(p,'Zombie Shop (Page '..(1 + id)..'),'..items)
		else
			zp_msg2(p,4,'This Feature Disabled By Admin!@C')
		end
	else
		zp_msg2(p,4,'[ZP] These Items Only For Zombies!')
	end
end

function zp_items_ld()
	f = io.open(zp_dir..'items.cfg','r')
	if (f ~= nil) then
		local m = 0
		zp_print(3,' Items File Found!')
		for line in f:lines() do
			m = m + 1
			if (string.sub(line, 1, 13) == '#addhumanitem') then
				local breaking = 0
				zp_ct_items_cnt =  zp_ct_items_cnt + 1
				local load_string = string.split(line,':')
				local i
				for i = 1, 6 do
					if (load_string[i + 1] ~= nil and breaking < 1) then
						if (i > 1) then
							set_ct_item_stata(zp_ct_items_cnt,i,tonumber(load_string[i + 1]))
						elseif (i < 2) then
							set_ct_item_stata(zp_ct_items_cnt,i,load_string[i + 1])
						end
					elseif (load_string[i + 1] == nil and breaking < 1) then
						zp_print(4,'Item Parameter Missing! ('..m..' line)')
						breaking = 1
						zp_ct_items_cnt = zp_ct_items_cnt - 1
					end
				end
				if (breaking == 0) then
					zp_print(6,'Human Item Added: '..set_ct_item_val(zp_ct_items_cnt,1))
				end

			end
			
			if (string.sub(line, 1, 14) == '#addzombieitem') then
				local breaking = 0
				zp_zm_items_cnt =  zp_zm_items_cnt + 1
				local load_string = string.split(line,':')
				local i
				for i = 1, 6 do
					if (load_string[i + 1] ~= nil and breaking < 1) then
						if (i > 1) then
							set_zm_item_stata(zp_zm_items_cnt,i,tonumber(load_string[i + 1]))
						elseif (i < 2) then
							set_zm_item_stata(zp_zm_items_cnt,i,load_string[i + 1])
						end
					elseif (load_string[i + 1] == nil and breaking < 1) then
						zp_print(4,'Item Parameter Missing! ('..m..' line)')
						breaking = 1
						zp_zm_items_cnt = zp_zm_items_cnt  - 1
					end
				end
				if (breaking == 0) then
					zp_print(6,'Zombie Item Added: '..set_zm_item_val(zp_zm_items_cnt,1))
				end
			end
			if (string.sub(line, 1, 17) == '#addhumanbuilding') then
			local breaking = 0
				zp_ct_items_cnt =  zp_ct_items_cnt + 1
				local load_string = string.split(line,':')
				local i
				for i = 1, 4 do
					if (load_string[i + 1] ~= nil and breaking < 1) then
						if (i > 1) then
							set_ct_item_stata(zp_ct_items_cnt,i,tonumber(load_string[i + 1]))
						elseif (i < 2) then
							set_ct_item_stata(zp_ct_items_cnt,i,load_string[i + 1])
						end
					elseif (load_string[i + 1] == nil and breaking < 1) then
						zp_print(4,'Item Parameter Missing! ('..m..' line)')
						breaking = 1
						zp_ct_items_cnt = zp_ct_items_cnt - 1
					end
				end
				
				if (breaking == 0) then
					local build_name = set_ct_item_val(zp_ct_items_cnt,1)
					build = io.open(zp_dir..'buildings/'..build_name..'.txt','r')
					if (build ~= nil) then
						local build_x = 0
						local build_y = 0
						for line in build:lines() do
							for x = 0, (#line) do
								if (zp_char_table[string.sub(line, x+1, x+1)] ~= nil) then
									zp_buildings[zp_ct_items_cnt.."_pos_"..x.."_"..build_y] = zp_char_table[string.sub(line, x+1, x+1)]
								end
								
							end
							build_y = build_y + 1
							build_x = #line
						end
						
						zp_buildings[zp_ct_items_cnt.."_x"] = build_x
						zp_buildings[zp_ct_items_cnt.."_y"] = build_y
						build:close()
					else
						zp_print(4,'Building File ('..build_name..') Missing!')
						set_ct_item_stata(zp_ct_items_cnt,1,nil)
						zp_ct_items_cnt = zp_ct_items_cnt - 1
						breaking = 1
					end
				end
				if (breaking == 0) then
					zp_print(6,'Human Building Added: '..set_ct_item_val(zp_ct_items_cnt,1))
				end
			end
		end
		f:close()
	else
		zp_print(4,'Items File Missing!')
	end
end

function zp_main_menu(p)
	menu(p,'Zombie Plague 1.1b Menu,Select Weapon|(Human),Choose Class|(Zombie),Humans Shop|(Human),Zombies Shop|(Zombie),Unstuck|(Zombie),Money > Ammo Packs|(Client),Join Zombies|(If Empty),Say Commands|(Client),Console Commands|(Admin)')
end

function zp_join_set(p)
	zp_light_eng[p] = 0
	zp_light_state[p] = -zp_hud_waste
	zp_class_menu_id[p] = 0
	zp_wpn_menu_id[p] = 0
	zp_item_menu_id[p] = 0
	zp_p_stun[p] = 0
	zp_help_close[p] = 0
	zp_p_join[p] = 0
	zp_p_class[p] = 0
	zp_p_weapons[p] = 0
	zp_p_last_class[p] = 0
	if (zp_join_msg > 0) then zp_msg2(p,8,'Welcome To Zombie Plague (v1.1) Server!@C') end
end

function zp_respawn(p)
	if (player(p,'team') == 1) then
		if (zp_tile_hit[p] > 0) then
			parse('setpos '..p..' '..zp_tile_x[p]..' '..zp_tile_y[p])
			zp_tile_hit[p] = 0
		else
			zp_msg2(p,4,'You Cant Cheat With This Command!@C')
		end
	else
		zp_msg2(p,4,'Only Zombie Can Use This!@C')
	end
end

function zp_buy_aps(p)
	menu(p,'Money to Ammo Packs,1 Ammo Pack|1000$,5 Ammo Packs|4000$,8 Ammo Packs|6000$,15 Ammo Packs|10000$,25 Ammo Packs|15000$')
end

function zp_ct_table()
	local ct = {}
	local ct_cnt = 0
	local p_table = player(0,'table')
	for i = 1, #player(0,'table') do
		if (player(p_table[i],'team') == 2) then
			ct_cnt = ct_cnt + 1
			ct[ct_cnt] = p_table[i]
		end
	end
	return ct
end

function zp_ct_cnt()
	local ct_cnt = 0
	for i = 1, p_cnt do
		if (player(i,'team') == 2) then
			ct_cnt = ct_cnt + 1
		end
	end
	return ct_cnt
end

function zp_hm_items_set(p,s)
	zp_msg2(p,3,'[ZP] You Have Bought: '..set_ct_item_val(s,1))
	if (set_ct_item_val(s,4) > 0) then
		parse('setmaxhealth '..p..' '..set_ct_item_val(s,4))
		parse('sethealth '..p..' '..set_ct_item_val(s,4))
	elseif (set_ct_item_val(s,4) < 0) then
		parse('setmaxhealth '..p..' '..player(p,'health') - set_ct_item_val(s,4))
		parse('sethealth '..p..' '..player(p,'health') - set_ct_item_val(s,4))
	end
	if (set_ct_item_val(s,5) > 0) then
		parse('setarmor '..p..' '..set_ct_item_val(s,5))
	elseif (set_ct_item_val(s,5) < 0) then
		parse('setarmor '..p..' '..player(p,'armor') - set_ct_item_val(s,5))
	end
	if (set_ct_item_val(s,6) > 0) then parse('speedmod '..p..' '..set_ct_item_val(s,6)) end
	if (set_ct_item_val(s,3) > 0) then
		parse('equip '..p..' '..set_ct_item_val(s,3))
		parse('setweapon '..p..' '..set_ct_item_val(s,3))
	end
end

function zp_zm_items_set(p,s)
	zp_msg2(p,8,'[ZP] You Have Bought: '..set_zm_item_val(s,1))
	if (set_zm_item_val(s,4) > 0) then
		zp_p_health[p] = set_zm_item_val(s,4)
	elseif (set_zm_item_val(s,4) < 0) then
	zp_p_health[p] = zp_p_health[p] - set_zm_item_val(s,4)
	end
	if (set_zm_item_val(s,5) > 0) then
		parse('setarmor '..p..' '..set_ct_item_val(s,5))
	elseif (set_zm_item_val(s,5) < 0) then
		parse('setarmor '..p..' '..player(p,'armor') - set_zm_item_val(s,5))
	end
	if (set_zm_item_val(s,6) > 0) then parse('speedmod '..p..' '..set_zm_item_val(s,6)) end
	if (set_zm_item_val(s,3) > 0 and set_zm_item_val(s,3) < 101) then
		parse('equip '..p..' '..set_zm_item_val(s,3))
		parse('setweapon '..p..' '..set_zm_item_val(s,3))
	elseif (set_zm_item_val(s,3) > 100) then
		zp_adv_items(p,set_zm_item_val(s,3))
	end
end

function zp_console_menu(p)
	local cmd = ''
	for i = 1,#zp_adm_cmd do
		cmd = cmd..''..zp_adm_cmd[i]..''..zp_adm_inf[i]..','
	end
	menu(p,'Console Commands (Admin)@b,'..cmd)
end

function zp_say_menu(p)
	local cmd = ''
	for i = 1,#zp_say_cmd do
		cmd = cmd..''..zp_say_cmd[i]..''..zp_say_inf[i]..','
	end
	menu(p,'Say Commands (Client),'..cmd)
end

function zp_adv_items(p,i)
	if (i == 101) then
		zp_item_tracker(p)
	else
		zp_msg2(p,4,'There Is No Special Item With This ID!@C')
	end
end

function zp_item_tracker(p)
	if (zp_ct_cnt() > 0) then
		local ct = zp_ct_table()
		local dir = {'North (up)','South (Down)','West (Left)','East (Right)'}
		local track = ct[math.random(1,zp_ct_cnt())]
		local msg = ''
		if (player(p,"y") > player(track,"y")) then
			msg = msg..''..dir[1]
		else
			msg = msg..''..dir[2]
		end
		
		if (player(p,"x") > player(track,"x")) then
			msg = msg..' - '..dir[3]
		else
			msg = msg..' - '..dir[4]
		end
		zp_msg2(p,2,'Selected Player Is '..player(track,"name")..'!@C')
		zp_msg2(p,2,'Survivor cordinates: '..msg..'!@C')
	else
		zp_msg2(p,4,'There Is No Survivors!@C')
	end
end


function zp_say_give(p,t)
	local parses = string.split(t)
	local v = tonumber(parses[2])
	local ap = tonumber(parses[3])
	if (v ~= nil and ap ~= nil) then
		if (p ~= v) then
			if (player(v,'exists')) then
				if (set_player_val(p,2) >= ap) then
					set_player_statb(p,2,-ap)
					set_player_statb(v,2,ap)
					zp_msg(2,player(p,'name')..' Gave His Own '..ap..' APs To '..player(v,'name')..'!')
					zp_msg2(v,2,player(p,'name')..' Gave You '..ap..' Ammo Packs!@C')
					zp_player_hud(v)
					zp_player_hud(p)
					zp_player_sv(v)
					zp_player_sv(p)
				else
					zp_msg2(p,4,'You Dont Have '..ap..' APs!')
				end
			else
				zp_msg2(p,4,'[ZP] Player Does Not Exist!')
			end
		else
			zp_msg2(p,4,'[ZP] You Cant Give APs to Yourself!')
		end
	else
		zp_msg2(p,4,'[ZP] Command Doesnt Have Right Parameters!')
	end
end

function zp_say_whatstats(p,t)
	local parses = string.split(t)
	local v = tonumber(parses[2])
	if (v ~= nil) then
		if (player(v,'exists')) then
				zp_msg(8,player(p,'name')..' Watching '..player(v,'name')..' Stats!')
				zp_msg2(p,6,'=== '..player(v,'name')..' Stats ===')
				zp_msg2(p,6,'Level: '..set_player_val(v,3))
				zp_msg2(p,6,'Experience: '..set_player_val(v,1)..'/'..set_player_val(v,4))
				zp_msg2(p,6,'Ammo Packs: '..set_player_val(v,2))
		else
			zp_msg2(p,4,'[ZP] Player Does Not Exist!')
		end
	else
		zp_msg2(p,4,'[ZP] Command Doesnt Have Right Parameters!')
	end
end
